/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.IntB;
import BryceMath.Numbers.ModularNumber;
import Data_Structures.ADTs.Pairable;
import Data_Structures.Structures.List;

public class FiniteInteger
extends ModularNumber<FiniteInteger> {
    private final long val;
    public static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    public static final int MIN_INT_VALUE = Integer.MIN_VALUE;
    public static final FiniteInteger ZERO = new FiniteInteger(0);
    public static final FiniteInteger ONE = new FiniteInteger(1);

    public FiniteInteger(int input) {
        this.val = input;
    }

    public FiniteInteger(long input) {
        this.val = input;
    }

    @Override
    public int toInt() {
        if (this.val > Integer.MAX_VALUE) {
            throw new Error("Error: INTEGER to big to be converted to int.");
        }
        return (int)this.val;
    }

    public long toLong() {
        return this.val;
    }

    @Override
    public FiniteInteger add(FiniteInteger n) {
        return this.i(this.val + n.val);
    }

    @Override
    public FiniteInteger add(int input) {
        return this.i(this.val + (long)input);
    }

    @Override
    public FiniteInteger sub(FiniteInteger n) {
        return this.i(this.val - n.val);
    }

    @Override
    public FiniteInteger sub(int input) {
        return this.sub(this.i(this.val - (long)input));
    }

    @Override
    public FiniteInteger mult(FiniteInteger n) {
        return this.i(this.val * n.val);
    }

    @Override
    public FiniteInteger mult(int n) {
        return this.i(this.val * (long)n);
    }

    @Override
    public Pairable<FiniteInteger> division(FiniteInteger input) {
        return new List<FiniteInteger>(this.div(input), this.mod(input));
    }

    @Override
    public FiniteInteger div(FiniteInteger n) {
        return this.i(this.val / n.val);
    }

    @Override
    public FiniteInteger div(int input) {
        return this.i(this.val / (long)input);
    }

    @Override
    public FiniteInteger mod(FiniteInteger n) {
        return this.i(this.val % n.val);
    }

    @Override
    public FiniteInteger mod(int input) {
        return this.i(this.val % (long)input);
    }

    @Override
    public boolean eq(FiniteInteger other) {
        return this.val == other.val;
    }

    @Override
    public boolean eq(int other) {
        return this.val == (long)other;
    }

    @Override
    public FiniteInteger sqrt() {
        return this.i((int)Math.sqrt(this.val));
    }

    @Override
    public FiniteInteger zero() {
        return ZERO;
    }

    @Override
    public FiniteInteger one() {
        return ONE;
    }

    @Override
    public int sign() {
        if (this.val < 0L) {
            return -1;
        }
        if (this.val == 0L) {
            return 0;
        }
        return 1;
    }

    private FiniteInteger i(long input) {
        return new FiniteInteger(input);
    }

    @Override
    FiniteInteger N(long n) {
        int n2 = (int)n;
        return new FiniteInteger(n2);
    }

    @Override
    public String toString() {
        return "" + this.val;
    }

    @Override
    public int hashCode() {
        return (int)this.val;
    }

    @Override
    public FiniteInteger neg() {
        return new FiniteInteger(-this.val);
    }

    @Override
    public boolean isNegative() {
        return this.val < 0L;
    }

    @Override
    public boolean isPositive() {
        return this.val > 0L;
    }

    @Override
    public FiniteInteger abs() {
        if (this.val < 0L) {
            return this.neg();
        }
        return this;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public IntB toIntB() {
        return new IntB(this.val);
    }
}

